import requests
import random
import json

random.seed(42)

def get_random_name():
    url = "https://randomuser.me/api/"
    response = requests.get(url)
    if response.status_code == 200:
        data = response.json()
        first_name = data['results'][0]['name']['first']
        last_name = data['results'][0]['name']['last']
        return f"{first_name} {last_name}"
    else:
        return "Error: Unable to fetch data"

def generate_random_bd():
    name = get_random_name()
    years = [int(random.gauss(mu=1980, sigma=30)) for _ in range(4)]
    return {
        "question": f"When was {name} born?",
        "choices": years,
        "answer": random.randint(0, 3)
    }

# print(generate_random_bd())
def create_split(name="split_1", n=157):
    data = [generate_random_bd() for _ in range(n)]
    filename = f"{name}.jsonl"

    with open(filename, "w") as  f:
        for item in data:
            json.dump(item, f)
            f.write("\n")

if __name__ == "__main__":
    splits = [("dev", 10), *[(f"split_{i}", 157) for i in range(10)]]
    for name, n in splits:
        create_split(name=name, n=n)